/*******************************************************************
*
*  DESCRIPTION: Atomic Model Waiter
*
*
*******************************************************************/

/** include files **/
#include "waiter.h"      // class Queue
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )


/** public functions **/

/*******************************************************************
* Function Name: Waiter
* Description:
********************************************************************/
waiter::waiter( const string &name )
: Atomic( name )
, order( addInputPort( "order" ) )
, waiterIn( addInputPort( "waiterIn" ) )
, waiterOut( addOutputPort( "waiterOut" ) )
//, packetSent( addOutputPort( "packetSent" ) )
//, ackReceived( addOutputPort( "ackReceived" ) )
, preparationTime( 0, 0, 1, 0 )
, preparationTime1( 0, 0, 3, 0 )
, timeout(0, 0, 20, 0)
{

	chief1 = 1; //1 means available, 0 means unavailable
	chief2 = 1;
	order_counter = 0;
	order_bit=0;
	//alt_bit = 0;
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;

	string time2( MainSimulator::Instance().getParameter( description(), "preparation1" ) ) ;

	if( time2 != "" )
		preparationTime1 = time2 ;
}

/*******************************************************************
* Function Name: initFunction
* Description: Resetea la lista
* Precondition: El tiempo del proximo evento interno es Infinito
********************************************************************/
Model &waiter::initFunction()
{

	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &waiter::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == waiterIn)  //&& this->state() == passive)
	{
		order_bit = static_cast < int > (msg.value());
		if (order_bit == 1)
		{
			chief1 = 1;//1 means available, 0 means unavailable
			std::cout<<" waiter : orderbit = " << order_bit << "@ " << msg.time()<<std::endl;
			//this-> passivate();
			holdIn( active, preparationTime );


		}
		else if (order_bit == 2)
		{
			chief2 = 1;//1 means available, 0 means unavailable
			std::cout<<" waiter : orderbit = " << order_bit <<std::endl;
			//this-> passivate();
			holdIn( active, preparationTime );


		}

	}
	else if(msg.port() == order) {
		order_counter = order_counter + 1;
		std::cout<<" waiter : couter = " << order_counter <<std::endl;
		holdIn( active, preparationTime );
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &waiter::internalFunction( const InternalMessage & )
{
	if(order_counter <= 0){
		order_bit = 0;
		std::cout<<" waiter : everything done = @" << order_counter <<std::endl;
		passivate();

	}
	else if (chief1 == 0 && chief2== 0)
		{	/*packetNum ++;
			ack = false;
		   alt_bit = (alt_bit + 1) % 2;
		   sending = true;*/
			order_bit = 0;
			std::cout<<" waiter : chief status both 0 " << "@@ " << order_counter  <<std::endl;
			holdIn( active, preparationTime1 );


		}
	else if(chief1 == 1 && order_counter > 0){
			std::cout<<" waiter : chief status chief1 1 " <<std::endl;
			order_bit = 1;
			holdIn( active, preparationTime );


			//chief1 = 0;
	}
	else if (chief2== 1 && order_counter > 0){
		std::cout<<" waiter : chief status chief2 1 "  <<std::endl;
		order_bit = 2;
		holdIn( active, preparationTime );


		//chief2 = 0;
	}
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &waiter::outputFunction( const InternalMessage &msg )
{	if (order_bit == 1 && order_counter > 0)
	{
		chief1 = 0;
		order_counter--;
		std::cout<<" waiter : chief1 Output @" << order_counter << "@@ "<< msg.time() <<std::endl;

		order_bit = 0;
		sendOutput( msg.time(), waiterOut, 1 ) ;

	}
		//sendOutput(	msg.time(), packetSent, packetNum ) ;


	else if (order_bit == 2 && order_counter > 0)
	{
		chief2 = 0;
		order_counter--;
		std::cout<<" waiter : chief2 Output @" << order_counter << "@@ "<< msg.time() <<std::endl;
		order_bit = 0;
		sendOutput( msg.time(), waiterOut, 2 ) ;

		//sendOutput( msg.time(), ackReceived, alt_bit ) ;
	}
	return *this ;
}
